local victory = false
local P1xpos, P2xpos, P1ypos, P2ypos
local cereal = false
local function isEditMode()
    local screen = SCREENMAN:GetTopScreen()
    if not screen then return nil end
    local screen = SCREENMAN:GetTopScreen()
    return (THEME:GetMetric(screen:GetName(), "Class") == "ScreenEdit")
end
local Frames = { Stretch = {
	{Frame= 3, Delay= 0.066},
	{Frame= 4, Delay= 0.066},
	{Frame= 5, Delay= 0.066},
	{Frame= 6, Delay= 0.066},
	{Frame= 7, Delay= 0.066},
	{Frame= 0, Delay= 0.066},
	{Frame= 1, Delay= 0.066},
	{Frame= 2, Delay= 0.066},
	{Frame= 0, Delay= 0.066},
	{Frame= 1, Delay= 0.066},
	{Frame= 2, Delay= 0.066},
	{Frame= 0, Delay= 0.066},
	{Frame= 1, Delay= 0.066},
	{Frame= 2, Delay= 0.066},
	{Frame= 0, Delay= 0.066},
	{Frame= 1, Delay= 0.066},
	{Frame= 2, Delay= 0.066}
},
Reverse = {
	{Frame= 2, Delay= 0.066},
	{Frame= 1, Delay= 0.066},
	{Frame= 0, Delay= 0.066},
	{Frame= 7, Delay= 0.066},
	{Frame= 6, Delay= 0.066},
	{Frame= 5, Delay= 0.066},
	{Frame= 4, Delay= 0.066},
	{Frame= 3, Delay= 0.066},
	{Frame= 3, Delay= 0.066},
	{Frame= 3, Delay= 0.066},
	{Frame= 3, Delay= 0.066},
	{Frame= 3, Delay= 0.066},

},
Idle = {
	{Frame= 0, Delay= 0.066},
	{Frame= 1, Delay= 0.066},
	{Frame= 2, Delay= 0.066},
	}
};
local t = Def.ActorFrame{}
local bugattis = {}
local bugatti = 1
local activeBugattis = 1
function createMissileExplosion(x, y)

end

local IsEditMode = function()
	local topscreen = SCREENMAN:GetTopScreen()
	if not topscreen then
	  lua.ReportScriptError("IsEditMode() check failed to run because there is no Screen yet.")
	  return nil
	end
  
	return (THEME:GetMetric(topscreen:GetName(), "Class") == "ScreenEdit")
  end
  
  -- helper function for returning the player AF
  -- works as expected in ScreenGameplay
  -- uses IsEditMode() to find the player AF if we're in EditMode
  --     arguments:  pn is a number like 1 or 2
  --     returns:    the "PlayerP1" or "PlayerP2" ActorFrame in ScreenGameplay
  --                 or, the unnamed equivalent in ScrenEdit
  local GetPlayerAF = function(pn)
	local topscreen = SCREENMAN:GetTopScreen()
	if not topscreen then
	  lua.ReportScriptError("GetPlayerAF() failed to find the player ActorFrame because there is no Screen yet.")
	  return nil
	end
  
	
	local playerAF = nil
  
	-- Get the player ActorFrame on ScreenGameplay
	-- It's a direct child of the screen and named "PlayerP1" for P1
	-- and "PlayerP2" for P2.
	-- This naming convention is hardcoded in the SM5 engine.
	--
	-- ScreenEdit does not name its player ActorFrame, but we can still find it.
  
	-- find the player ActorFrame in edit mode
	if IsEditMode() then
	  -- loop through all nameless children of topscreen
	  -- and find the one that contains the NoteField
	  -- which is thankfully still named "NoteField"
	  for _,nameless_child in ipairs(topscreen:GetChild("")) do
		if nameless_child:GetChild("NoteField") then
		  playerAF = nameless_child
		  break
		end
	  end
  
	-- find the player ActorFrame in gameplay
	else
	  local player_af = topscreen:GetChild("PlayerP"..pn)
	  if player_af then
		playerAF = player_af
	  end
	end
  
	return playerAF
  end
local adanFrames = {
	Talking = {
		{ Frame=1,	Delay=0.09},
        { Frame=2,	Delay=0.09},
	},
    Lose = {
		{ Frame=0,	Delay=0.09},
	},
	Shooting = {
		{ Frame=3,	Delay=0.15},
		{ Frame=4,	Delay=0.1},
        { Frame=3,	Delay=0.1},
		{ Frame=4,	Delay=0.1},
        { Frame=3,	Delay=0.1},
		{ Frame=4,	Delay=0.1},
        { Frame=3,	Delay=0.1},
		{ Frame=4,	Delay=0.1},
        { Frame=5,	Delay=0.4},
	},

}

function DoSound(str)
	local songName = GAMESTATE:GetCurrentSong():GetSongDir();
	SOUND:PlayOnce(songName..'lua/sounds/'..str..'.ogg');
end
function DoBulletSound()
	local songName = GAMESTATE:GetCurrentSong():GetSongDir();
	SOUND:PlayOnce(songName..'lua/sounds/laser.mp3');
end
function DoRandomSound()
	local str = ""
	local randomNum = math.random(1,9)
	local songName = GAMESTATE:GetCurrentSong():GetSongDir();
	if randomNum == 1 then
		str = "BabyNoise"
	elseif randomNum == 2 then
		str = "BreathAir"
	elseif randomNum == 3 then
		str = "Females"
	elseif randomNum == 4 then
		str = "haram"
	elseif randomNum == 5 then
		str = "OneHand"
	elseif randomNum == 8 then
		str = "BreathAir"
	else
		str = "haram"
	end
	SOUND:PlayOnce(songName..'lua/sounds/'..str..'.ogg');
end
function simple_m0d(beat,strength,mult,mod,pn)
	if not strength then strength = 400 end
	if not mult then mult = 1 end
	if not mod then mod = 'drunk' end
	
	local alive = math.max(2*mult*math.abs(strength)/100,0.25)
	
	table.insert(mods,{beat,'*100000 '..strength..' '..mod,pn});
	table.insert(mods,{beat+.1,'*'..((1/mult)*math.abs(strength)/100)..' no '..mod,pn});
end
--alternates a mod back and forth before resetting to 0
--beat,num,div,amt,mod,pn
function mod_wiggle(beat,num,div,amt,mod,pn,first)
	local fluct = 1
	for i=0,(num-1) do
		b = beat+(i/div)
		local m = 1
		if i==0 and not first then m = 0.5 end
		table.insert(mods,{b,'*'..math.abs(m*amt/10)..' '..(amt*fluct)..' '..mod..'',pn});
		fluct = fluct*-1;
	end
	table.insert(mods,{beat+(num/div),'*'..math.abs(amt/20)..' no '..mod..'',pn});
end

function mod_bamBaBamBaBam(beat,amt,mult,mod)
	simple_m0d(beat,amt,mult,mod);
	--simple_m0d(beat+1,amt,mult,mod);
	simple_m0d(beat+1.5,amt,mult,mod);
	--simple_m0d(beat+2.5,amt,mult,mod);
	simple_m0d(beat+3,amt,mult,mod);
end

function mod_baBamBaBam(beat,amt,mult,mod)
	simple_m0d(beat,amt,mult,mod);
	simple_m0d(beat+0.5,amt,mult,mod);
	simple_m0d(beat+1.5,amt,mult,mod);
	simple_m0d(beat+2,amt,mult,mod);
end

-- TODO READD multicharacter function
local characters = {"Andrew Tate", "Greta"}
-- Not including Epilogue Characters or map NPCs
local speaker = "Andrew Tate"
local bigImages = false
----------------------------------------------------------------------------
----------------------------------------------------------------------------
local P1, P2, P1Score, P2Score
local difficulty, sTable
local colorDefault = "#ffffff"
local textDefault = 0.02
local textComma = 0.28
local textPeriod = 0.14
local textExclamation = 0.9
local textQuestion = 0.36
local currentSong = GAMESTATE:GetCurrentSong()
text_actor = {}
local path = currentSong:GetSongDir()

local textMessage = 'test'
local textCounter
local box_flag = false
--[[

	Some of the code below here is part of the "Preliminary Check"
	We want to just check on a couple things to ensure a safe flight

	1. Version Warning - Stepmania Versions above 5.1 seem to interpet the mods differently
	2. Edit Chart - If the player is in Edit Mode or is on the Edit Chart, the mods do not play
	3. Mixmatch Choices - If one player is on Edit and the other is not, then both get set to Edit
		This is to ensure that no one is able to get a score on the modded charts by playing/reading an
		unmodded chart

]] --

function getStats()
    local combo1 = 0
    local combo2 = 0
    local percent1 = 0
    local percent2 = 0
    if P1 then
        combo1 = STATSMAN:GetCurStageStats():GetPlayerStageStats(0)
                     :GetCurrentCombo()
    end
    if P2 then
        combo2 = STATSMAN:GetCurStageStats():GetPlayerStageStats(1)
                     :GetCurrentCombo()
    end
    if combo1 < combo2 then combo1 = combo2 end

    if P1 then
        percent1 = math.ceil(STATSMAN:GetCurStageStats():GetPlayerStageStats(0)
                                 :GetPercentageOfTaps('TapNoteScore_W1') * 100)
    end
    if P2 then
        percent2 = math.ceil(STATSMAN:GetCurStageStats():GetPlayerStageStats(1)
                                 :GetPercentageOfTaps('TapNoteScore_W1') * 100)
    end

    if percent1 < percent2 then percent1 = percent2 end

    return "Impressive.. " .. combo1 .. " combo w/ a " .. percent1 ..
               "% fantastic ratio";

end
function zoomPlayers(amt,spd)
	if SCREENMAN:GetTopScreen():GetChild('PlayerP1') then
		P1:bounceend(spd)
		P1:zoom(amt)
	end
	
	if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
		P2:bounceend(spd)
		P2:zoom(amt)
	end
end

function skewPlayers(amt,spd)
	if SCREENMAN:GetTopScreen():GetChild('PlayerP1') then
		P1:linear(spd)
		P1:skewx(amt)
	end
	
	if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
		P2:linear(spd)
		P2:skewx(amt)
	end
end

function zoomxyPlayers(amtx,amty,spd)
	if SCREENMAN:GetTopScreen():GetChild('PlayerP1') then
		P1:linear(spd)
		P1:zoomx(amtx)
		P1:zoomy(amty)
	end
	
	if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
		P2:linear(spd)
		P2:zoomx(amtx)
		P2:zoomy(amty)
	end
end
function screenShake(num)
	if isEditMode() then
		return;
	end
	if not SongForeGround then
		SongForeground = SCREENMAN:GetTopScreen():GetChild('SongForeground')
	end
			
	if num==1 then
	--screen:vibrate()
	--screen:effectmagnitude(20,20,0)
	SongForeground:vibrate()
	SongForeground:effectmagnitude(20,20,0)
	SongBackground:vibrate()
	SongBackground:effectmagnitude(20,20,0)
	
		if SCREENMAN:GetTopScreen():GetChild('PlayerP1') then
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('NoteField'):vibrate()
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('NoteField'):effectmagnitude(20,20,0)
		end
		
		if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('NoteField'):vibrate()
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('NoteField'):effectmagnitude(20,20,0)
		end
	
	elseif num==2 then
	SongForeground:vibrate()
	SongForeground:effectmagnitude(40,40,0)
	SongBackground:vibrate()
	SongBackground:effectmagnitude(40,40,0)
	
	
		if SCREENMAN:GetTopScreen():GetChild('PlayerP1') then
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('NoteField'):vibrate()
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('NoteField'):effectmagnitude(40,40,0)
		end
		
		if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('NoteField'):vibrate()
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('NoteField'):effectmagnitude(40,40,0)
		end
	
	
	elseif num==10 then
	SongForeground:vibrate()
	SongForeground:effectmagnitude(100,100,0)
	SongBackground:vibrate()
	SongBackground:effectmagnitude(100,100,0)
	
	
		if SCREENMAN:GetTopScreen():GetChild('PlayerP1') then
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('NoteField'):vibrate()
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('NoteField'):effectmagnitude(100,100,0)
		end
		
		if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('NoteField'):vibrate()
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('NoteField'):effectmagnitude(100,100,0)
		end
	
	else
	SongForeground:stopeffect()
	SongBackground:stopeffect()
	
		if SCREENMAN:GetTopScreen():GetChild('PlayerP1') then
			SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('NoteField'):stopeffect()
		end
		
		if SCREENMAN:GetTopScreen():GetChild('PlayerP2') then
			SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('NoteField'):stopeffect()
		end
	end
end
function TextSet(text, character)
    if not box_flag then
		if character == nil then
			character = "Andrew Tate"
		end
        text_actor[character]:queuecommand('Show')
        text_actor.speaker:queuecommand('Show')
    end

    textMessage = text
    textCounter = 0
    text_actor.mainText:queuecommand('Type')
end
function MoveImage()
	bigImages = false
	text_actor.box:visible(false)
	text_actor.box2:visible(true):queuecommand("Show")
	text_actor.box2:visible(true)
	text_actor.box2:GetParent():queuecommand("Reveal")

end
function MoveImageBack()
	bigImages = false
	text_actor.box:visible(true)
	text_actor.box:GetParent():queuecommand("Unveal")
	text_actor.box2:visible(true):diffusealpha(1):queuecommand("Show")
	text_actor.box3:visible(true):diffusealpha(1):queuecommand("Show")


end
function TextClear()
    text_actor.speaker:queuecommand('TextClear')
    text_actor.mainText:queuecommand('TextClear')
    if box_flag then MESSAGEMAN:Broadcast('HideBox') end
end
-- --Returns true if either P1 or P2 is passing
-- function PassCheck()
-- 	if P1 then
-- 		if not STATSMAN:GetCurStageStats():GetPlayerStageStats(0):GetFailed() then
-- 			return true
-- 		end
-- 	end
-- 	if P2 then
-- 		if not STATSMAN:GetCurStageStats():GetPlayerStageStats(1):GetFailed() then
-- 			return true
-- 		end
-- 	end
-- 	if isEditMode() then
-- 		return true
-- 	end
-- 	return false
-- end

local version = tonumber(string.match(ProductID(), '%d+%.?%d*$')) or 5.0;
if version > 5.1 then
    SCREENMAN:SystemMessage('Sorry, this song was made for SM 5.1');
end

local WideScale = function(AR4_3, AR16_9)
    -- return scale( SCREEN_WIDTH, 640, 854, AR4_3, AR16_9 )
    local w = 480 * PREFSMAN:GetPreference("DisplayAspectRatio")
    return scale(w, 640, 854, AR4_3, AR16_9)
end

-- Mods to be applied, Number denotes the Mission these mods are applied
local mods1 = {
	{98, '*5 500% Beat'},
	{126, '*5 no Beat'},
    {130, '*5 100% Beat'},
	{162, '*5 300% Beat'},
	{194, '*5 300% Beat, *0.5 65% randomvanish, *0.1 60% Wave'},
	{196, '*10 3000% Confusion'},
	{198, '*10 no Confusion'},
	{204, '*10 2000% Confusion'},
	{206, '*10 no Confusion'},
	{212, '*10 2000% Confusion'},
	{214, '*10 no Confusion'},
	{220, '*10 2000% Confusion'},
	{222, '*10 no Confusion'},
	{228, '*10 2000% Confusion'},
	{230, '*10 no Confusion'},
	{236, '*10 2000% Confusion'},
	{240, '*10 no Confusion, *1 no randomvanish'},

	{251, '*5 1000% Beat, no Blink, *2 no Wave'},
	{303, '*5 30% Flip'},
	{306, '*5 no Flip'},
	{306+1, '*5 -125% Flip'},
	{310, '*1 no Flip'},
	{311, '*20 1000% Confusion, *5 50% Centered'},
	{315, '*5 no Flip, no Confusion, *5 no Centered'},
    {319.5, '*1 20% Confusion, *5 150% Centered, *5 5% Tornado, *20 150% Bumpy'},
	{321, '*30 no Confusion, *5 no Centered, *5 5% Tornado, *20 150% Bumpy'},
	{328, '*30 no Confusion, *1 no Beat'},

    {384, '*2 2% Confusion, *1 50% Space, *0.5 20% Expand'},
    {385, '*2 0% no Confusion'}, 
	{495.5, 'clearall'}
}

local dialogue1 = {
	{98,function()
		MESSAGEMAN:Broadcast('WhiteFlash');
		
		for _,pe in pairs(GAMESTATE:GetEnabledPlayers()) do
			local pn = tonumber(string.match(pe, "[0-9]+"))
			local a   = GetPlayerAF(pn)
			if a then
				a:x(SCREEN_CENTER_X);
				a:y(SCREEN_CENTER_Y);
				a:bob();
				a:zoom(0.9)
				a:effectclock('bgm');
				a:effectmagnitude(-64,0,0);
				a:effectperiod(4);
			end
		end
		if P1 and P2 then
			local jud1 = P1:GetChild('Judgment')
			local com1 = P1:GetChild('Combo')
			--local jud2 = P2:GetChild('Judgment')
			--local com2 = P2:GetChild('Combo')
			--[[
			jud1:x(-60);
			com1:x(-60);
			jud2:x(60);
			com2:x(60);
			]]
			
			-- --retarded
			-- jud1:bob()
			-- jud1:effectmagnitude(-60,0,0)
			-- jud1:effectperiod(1000000)
			-- jud1:effectoffset(250000)
			-- com1:bob()
			-- com1:effectmagnitude(-60,0,0)
			-- com1:effectperiod(1000000)
			-- com1:effectoffset(250000)
			-- jud2:bob()
			-- jud2:effectmagnitude(60,0,0)
			-- jud2:effectperiod(1000000)
			-- jud2:effectoffset(250000)
			-- com2:bob()
			-- com2:effectmagnitude(60,0,0)
			-- com2:effectperiod(1000000)
			-- com2:effectoffset(250000)
			
			-- jud1:basezoomx(0.80);
			-- jud1:basezoomy(0.80);
			-- com1:basezoomx(0.80);
			-- com1:basezoomy(0.80);
			-- jud2:basezoomx(0.80);
			-- jud2:basezoomy(0.80);
			-- com2:basezoomx(0.80);
			-- com2:basezoomy(0.80);
		end
	end},
	{0, function() TextSet("What is this?", "Andrew Tate") end},
	{5, function() TextSet("Someone let another pathetic loser into my studio") end},
	{10, function() 
		local profileName
		if (PROFILEMAN:IsPersistentProfile(PLAYER_1) and PROFILEMAN:IsPersistentProfile(PLAYER_2)) then
			profileName = PROFILEMAN:GetProfile(PLAYER_2):GetDisplayName() .. ", ".. PROFILEMAN:GetProfile(PLAYER_1):GetDisplayName()
			TextSet(profileName.. "? What kind of names are that? You expect to get maidens with names like that?") 

		elseif (PROFILEMAN:IsPersistentProfile(PLAYER_1)) then
			profileName = PROFILEMAN:GetProfile(PLAYER_1):GetDisplayName()
			TextSet(profileName.. "? What kind of name even is that? You expect to get maidens with a name like that?") 
		elseif (PROFILEMAN:IsPersistentProfile(PLAYER_2)) then
			profileName = PROFILEMAN:GetProfile(PLAYER_2):GetDisplayName()
			TextSet(profileName.. "? What kind of name even is that? You expect to get maidens with a name like that?") 
		else
			TextSet("Pfft who even are you? You expect to get maidens being nameless like that?") 
		end
	end},
	{18, function() TextSet("Look kid, It's not personal, it's a fact.") end},
	{25, function() TextSet("What are you? Some kind of gamer? Another geek who sits around all day") end},
	{33, function() TextSet("A Top G like me doesn't sit around and play with pixels. I have a Bugatti") end},
	{41, function() TextSet("Look at me, what do you see?") end},
	{46, function() TextSet("I'll tell you what you see. You see a warrior, a champion, a KING") end},
	{55, function() TextSet("And a King like myself doesn't have time to continue educating the weak") end},
	{61, function() TextSet("What? You're sitting here questioning my status?") end},
	{66, function() TextSet("I am a GOD amongst men. I am a TOP. I am THE TOP.") end},
	{74, function() TextSet("I am the voice for all men under 13. I speak for those who have yet to speak") end},
	{81, function() TextSet("Do you know the power I possess? And you come here insulting me and my empire?") end},
	{88, function() TextSet("I think it's time for you to meet the real me") end},
	{93, function() TextSet("The REAL BIG BOSS") end},
	{100, function() TextClear() end},
	{120, function() TextSet("Adin! Show them my Bugatti", "Andrew Tate") end},
    {124, function() TextClear() end},
					
	{128.5,function(self)
		MESSAGEMAN:Broadcast('WhiteFlashLong');
		for _,pe in pairs(GAMESTATE:GetEnabledPlayers()) do
			local pn = tonumber(string.match(pe, "[0-9]+"))
			local a   = GetPlayerAF(pn)
			if a then
				a:x(SCREEN_CENTER_X);
				a:y(SCREEN_CENTER_Y);
				a:bob();
				a:zoom(0.9)
				a:effectclock('bgm');
				a:effectmagnitude(0,0,0);
				a:effectperiod(4);
			end
		end
		starSpellCont:visible(true)
		--DoSound('load')
		-- rainbowHappening=0
		-- as_heads:animate(0)
		-- as_heads:setstate(10)
		-- as_armLs:setstate(5)
		-- as_armRs:setstate(5)
		
	end},
	{140+2,function(self)
	
		-- Star2:visible(true):rotationz(-45)
		-- Star2:sleep(0.24975*12)
		-- Star2:x(400+80)
		-- Star2:y(400)
		-- Star2:linear(0.351*1.5)
		-- Star2:x(80)
		-- Star2:y(0)
		
		-- Star1:visible(true):rotationz(-45)
		-- Star1:sleep(0.24975*26)
		-- Star1:x(400+20)
		-- Star1:y(-400-50)
		-- Star1:linear(0.351*3.5)
		-- Star1:x(40)
		-- Star1:y(-120)

		-- Star4:visible(true):rotationz(-45)
		-- Star4:sleep(0.24975*26)
		-- Star4:x(400+20)
		-- Star4:y(-400-50)
		-- Star4:linear(0.351*3.5)
		-- Star4:x(40)
		-- Star4:y(-120)
		-- zoomPlayers(0.6,0.2)
	end},
	{132+2,function(self)
					
		DoSound('star3')
		Star5:visible(true)
		Star5:x(400):rotationz(-45)
		Star5:y(-400)
		Star5:linear(0.24975*2.5)
		Star5:x(100)
		Star5:y(-100)
	end},
	{133.5+2,function(self)
					
		DoSound('ex')
		sendLilStars5(50,900,10)
		screenShake(10)
		
		if GetPlayerAF(1) then
			P1:spring(0.8)
			P1:rotationz(-20)
			P1:x(SCREEN_CENTER_X-100)
			P1:y(SCREEN_CENTER_Y+50)
			P1:zoom(0.6)
		end
		
		if GetPlayerAF(2) then
			P2:spring(0.8)
			P2:rotationz(-20)
			P2:x(SCREEN_CENTER_X-100)
			P2:y(SCREEN_CENTER_Y+50)
			P2:zoom(0.6)
		end
		
	end},
		
	{133.8+2,function(self)
		
		screenShake()
	end},

	{133.8+2,function(self)
		screenShake()
	end},
	----------------------------------
	{136+2,function(self)
		
		DoSound('star2')
		Star3:visible(true)
		Star3:rotationz(-45)
		Star3:x(-400)
		Star3:y(-400+50)
		Star3:linear(0.351*2.5)
		Star3:x(-50)
		Star3:y(0)
		
	end},
	
	{138.5+1,function(self)
		
		DoSound('ex')
		sendLilStars3(50,300,10)
		screenShake(10)
		
		if GetPlayerAF(1) then
			P1:spring(0.8)
			P1:rotationz(20)
			P1:x(SCREEN_CENTER_X+100)
			P1:y(SCREEN_CENTER_Y+50)
			P1:zoom(1)
		end
		
		if GetPlayerAF(2) then
			P2:spring(0.8)
			P2:rotationz(20)
			P2:x(SCREEN_CENTER_X+100)
			P2:y(SCREEN_CENTER_Y+50)
			P2:zoom(1)
		end
		
	end},
	
	{138.8+1,function(self)
		
		screenShake()
		
	end},
	-----------------------------------
	{141+1,function(self)
		
		DoSound('star0')
		Star2:visible(true):rotationz(-45)
		Star2:x(400+80)
		Star2:y(400)
		Star2:linear(0.351*1.5)
		Star2:x(80)
		Star2:y(0)
		
	end},
	
	{142.5+1,function(self)
		
		DoSound('ex')
		screenShake(10)
		sendLilStars2(50,900,10)
		
		if GetPlayerAF(1) then
			P1:spring(0.8)
			P1:rotationz(-20)
			P1:x(SCREEN_CENTER_X+20)
			P1:y(SCREEN_CENTER_Y-100)
			P1:zoom(0.5)
		end
		
		if GetPlayerAF(2) then
			P2:spring(0.8)
			P2:rotationz(-20)
			P2:x(SCREEN_CENTER_X+20)
			P2:y(SCREEN_CENTER_Y-100)
			P2:zoom(0.5)
		end
		
	end},
	
	{142.8+1,function(self)
		
		screenShake()
		
	end},
	-----------------------
	{144+1.7,function(self)
		
		DoSound('star1')
		Star1:visible(true):rotationz(-45)
		Star1:x(100)
		Star1:y(-500)
		Star1:linear(0.351*3.5)
		Star1:x(40)
		Star1:y(-120)
	end},
	
	{146.5+1,function(self)
		
		DoSound('ex')
		sendLilStars1(50,900,10)
		screenShake()
		
		if GetPlayerAF(1) then
			P1:spring(0.8)
			P1:rotationz(0)
			P1:x(SCREEN_CENTER_X-000)
			P1:y(SCREEN_CENTER_Y+100)
			P1:zoom(0.5)
		end
		
		if GetPlayerAF(2) then
			P2:spring(0.8)
			P2:rotationz(0)
			P2:x(SCREEN_CENTER_X-000)
			P2:y(SCREEN_CENTER_Y+100)
			P2:zoom(0.5)
		end
		
	end},
	
	{146.8+1,function(self)
		
		screenShake()
		
	end},

	---------------------------	
	{149.8,function(self)
		
		DoSound('star1')
		Star4:visible(true):rotationz(45)
		Star4:x(-800)
		Star4:y(-200)
		Star4:linear(0.351*2.5)
		Star4:x(0)
		Star4:y(0)
	end},
	
	{151.5,function(self)
		
		DoSound('ex')
		sendLilStars4(50,900,10)
		screenShake()
		
		if GetPlayerAF(1) then
			P1:spring(0.8)
			P1:rotationz(50)
			P1:x(SCREEN_CENTER_X+250)
			P1:y(SCREEN_CENTER_Y+20)
			P1:zoom(0.8)
		end
		
		if GetPlayerAF(2) then
			P2:spring(0.8)
			P2:rotationz(50)
			P2:x(SCREEN_CENTER_X+250)
			P2:y(SCREEN_CENTER_Y+20)
			P2:zoom(0.75)
		end
		
	end},
	
	{151.8,function(self)
		
		screenShake()
		
	end},
	----------------
	{153.8,function(self)
	
		DoSound('star2')
		resetStar5()
		Star5:visible(true):rotationz(-45)
		Star5:x(-600)
		Star5:y(200)
		Star5:linear(0.351*2.5)
		Star5:x(150)
		Star5:y(0)
		
	end},
	{153.8,function(self)
		Star6:visible(true):rotationz(45)
		Star6:x(600)
		Star6:y(200)
		Star6:linear(0.351*2.5)
		Star6:x(150)
		Star6:y(0)
		
	end},
	
	{155.5,function(self)
		
		DoSound('ex')
		sendLilStars5(50,900,10)
		sendLilStars6(50,900,10)
		screenShake()
		if GetPlayerAF(1) then
			P1:spring(0.8)
			P1:rotationz(360)
			P1:x(P1xpos)
			P1:y(P1ypos)
		end
		
		if GetPlayerAF(2) then
			P2:spring(0.8)
			P2:rotationz(-360)
			P2:x(P2xpos)
			P2:y(P2ypos)
		end
		zoomPlayers(1,1)

	end},
	
	{156.8,function(self)
		
		screenShake()
		
	end},
	------------
	{157.8,function(self)
	
		DoSound('star2')
		
	end},
	
	{157,function(self)
		HugeStar1:visible(true)
		HugeStar1:x(500):zoom(2)
		HugeStar1:y(-500)
		HugeStar1:linear(0.351*4)
		HugeStar1:x(-280)
		HugeStar1:y(150)
		HugeStar1s:linear(0.351*4)
		HugeStar1s:rotationz(-360*1)
		Hugetrail1:linear(0.351*8)
		Hugetrail1:rotationz(-360*1)
		Hugetrail2:linear(0.351*4)
		Hugetrail2:rotationz(-360*1)
		StarGlowThing:visible(true)
		StarGlowThing:x(500)
		StarGlowThing:y(-500)
		StarGlowThing:linear(0.351*4)
		StarGlowThing:x(-280)
		StarGlowThing:y(150)
		setExStars()
	end},
	
	{159,function(self)
		
		DoSound('bigStar')
		
	end},
	
	{161.5,function(self)
		
		DoSound('exBig')
		if GetPlayerAF(1) then
			P1:linear(0.8)
			P1:x(P1xpos)
			P1:y(P1ypos)
		end
		
		if GetPlayerAF(2) then
			P2:linear(0.8)
			P2:x(P2xpos)
			P2:y(P2ypos)
		end
		screenShake()
		StarGlowThing:linear(0.25):diffusealpha(0)
		Hugetrail1:linear(0.25):diffusealpha(0)
		Hugetrail2:linear(0.25):diffusealpha(0)
		HugeStar1:linear(0.25):diffusealpha(0)
		HugeStar1s:linear(0.25):diffusealpha(0)	
	end},

	{161.8,function(self)
		AllStars:linear(3):diffusealpha(0)
	end},
	{170,function(self)
		AllStars:visible(false)
	end},

	


    {164, function() TextSet("So you beat Adin? HA! PREDICTABLE", "Andrew Tate") end},
    {170, function() TextSet("Everybody knows he was never a Top G. Just another soy boy like the rest of them") end},
    {176, function() TextSet("Not everyone can be a Big Boss like me. It's tough living in a world like this") end},
	{182, function() TextSet("What you think I'M gonna fight you? HA!") end},
	{185, function() TextSet("I'm not the only one who knows how to let another man do his dirty work") end},
    {190.5, function() TextSet("Sneako show them out") end},
	
    {194, function() TextClear() end},
	{250, function() TextSet("Hmph you think this makes you a Big Boss?", "Andrew Tate") end},
	{254, function() TextSet("You think you can take on THE MR. PRODUCER?!?") end},
	{259, function() TextClear() end},
    {260, function() MoveImage(); TextSet("YOU ARE NOTHING. A SPECK. ANOTHER PEPPERONI IN THE PIZZA BOX.", "Andrew Tate") end},
    {267, function() TextSet("IMAGINE having the entire WORLD in the palm of your hands") end},
	{274, function() TextSet("You brokees are too worried about global warming... When you should be thanking ME!") end},
	{280, function() TextSet("Thanking ME for keeping the earth warm in the hands OF.. A REAL...T O P... G") end},
	{288, function() TextSet("NOW DIE!") end},
	{323, function() MoveImageBack(); TextSet("What?!?", "Andrew Tate") end},
	{326, function() TextClear() end},
	{327, function() TextSet("Oh. Did someone say pizza?", "Greta") end},
	{330, function() TextClear() end},
	{331, function() TextSet("YOU??!", "Andrew Tate") end},
	{334, function() TextSet("YOUR PRESENCE MAKES NO DIFFERENCE") end},
	{338, function() TextSet("YOU CAN ALL FACE MY FULL MIGHT!!") end},
	{343, function() TextClear() end},
	{344, function() TextSet("Hm, let's put this giant to rest", "Greta") end},
	{347, function() TextSet("If we can clear the area of all Tatettes, we will finally defeat him") end},
	{352.5, function() TextClear() end},
	{353, function() TextSet("I AM INEVITABLE!!", "Andrew Tate") end},
	{356, function() TextClear() end},
	{193, function() DoSound("OneHand") end},
	{210, function() DoSound("BreathAir") end},
	{220, function() DoSound("haram") end},
	{232, function() DoSound("Bugatti") end},
	{244, function() DoSound("Females") end},
	{256, function() DoSound("BreathAir") end},

    {289.5,function() DoSound('gaster_spawn') end},
	{291.5,function() DoSound('gaster_fire') end},
	{293.5,function() DoSound('gaster_spawn') end},
    {295.5,function() DoSound('gaster_fire') end},
    {297.5,function() DoSound('gaster_spawn') end},
    {299.5,function() DoSound('gaster_fire') end},
    {301.5,function() DoSound('gaster_spawn') end},
    {303.5,function() DoSound('gaster_fire') end},
    {305.5,function() DoSound('gaster_spawn') end},
    {307.5,function() DoSound('gaster_fire') end},
    {309.5,function() DoSound('gaster_spawn') end},
    {311.5,function() DoSound('gaster_fire') end},
    {313.5,function() DoSound('gaster_spawn') end},
    {315.5,function() DoSound('gaster_fire') end},
    {317.5,function() DoSound('gaster_spawn') end},
    {319.5,function() DoSound('gaster_fire') end},
	{290,function()
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1.5);
		a:x(-100);
		a:y(100);
		a:decelerate(0.5);
		a:x(SCREEN_CENTER_X/4);
		a:rotationz(720);
		a:sleep(0.5);
		a:rotationz(0);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(-SCREEN_HEIGHT/2)
		a:sleep(2); a:queuecommand('Done');
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1.5);
		a:x(SCREEN_WIDTH+100);
		a:y(100);
		a:decelerate(0.5);
		a:x(SCREEN_CENTER_X*1.75);
		a:rotationz(-720);
		a:sleep(0.5);
		a:rotationz(0);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(-SCREEN_HEIGHT/2)
		a:sleep(2); a:queuecommand('Done');
		
		for _,pe in pairs(GAMESTATE:GetEnabledPlayers()) do
			local pn = tonumber(string.match(pe, "[0-9]+"))
			local a   = GetPlayerAF(pn)
			if a then
				if (IsEditMode()) then
					a:x(pn == 1 and P1xpos or P2xpos)
					a:y(pn == 1 and P1ypos or P2ypos)
				end
				a:z(1);
				a:sleep(0.4);
				a:linear(0.1);
				a:addx((pn==1 and 1 or -1)*SCREEN_CENTER_X/2 )
				a:rotationz(10)
				a:linear(0.1);
				a:y(SCREEN_CENTER_Y)
				a:rotationz(0)
			end
		end
		
	end},
    {294,function()
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1.5);
		a:x(-100);
		a:y(100);
		a:decelerate(0.5);
		a:x(SCREEN_CENTER_X-192);
		a:rotationz(720);
		a:sleep(0.5);
		a:rotationz(0);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(-SCREEN_HEIGHT/2)
		a:sleep(2); a:queuecommand('Done');
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1.5);
		a:x(SCREEN_WIDTH+100);
		a:y(100);
		a:decelerate(0.5);
		a:x(SCREEN_CENTER_X);
		a:rotationz(-720);
		a:sleep(0.5);
		a:rotationz(0);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(-SCREEN_HEIGHT/2)
		a:sleep(2); a:queuecommand('Done');
		
		for _,pe in pairs(GAMESTATE:GetEnabledPlayers()) do
			local pn = tonumber(string.match(pe, "[0-9]+"))
			local a   = GetPlayerAF(pn)
			if a then
				a:z(1);
				a:sleep(0.35);
				a:accelerate(0.15);
				a:addx(192/2)
				a:rotationz(10)
				a:decelerate(0.15);
				a:addx(192/2)
				a:rotationz(0)
			end
		end
		
	end},
    {298,function()
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1.5);
		a:x(SCREEN_WIDTH+100);
		a:y(SCREEN_HEIGHT*0.75);
		a:decelerate(0.5);
		a:x(SCREEN_WIDTH-100);
		a:rotationz(720+90);
		a:sleep(0.5);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addx(200)
		a:sleep(2); a:queuecommand('Done');
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1.5);
		a:x(SCREEN_WIDTH*0.75);
		a:y(SCREEN_HEIGHT+100);
		a:decelerate(0.5);
		a:y(SCREEN_HEIGHT-100);
		a:rotationz(-720+180);
		a:sleep(0.5);
		a:rotationz(180);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(200)
		a:sleep(2); a:queuecommand('Done');
		
		for _,pe in pairs(GAMESTATE:GetEnabledPlayers()) do
			local pn = tonumber(string.match(pe, "[0-9]+"))
			local a   = GetPlayerAF(pn)
			if a then
				a:z(1);
				a:sleep(0.35);
				a:accelerate(0.15);
				a:addx(-128)
				a:rotationz(180-8)
				a:decelerate(0.15);
				a:addx(-128)
				a:rotationz(360-15)
				a:sleep(0)
				a:rotationz(-15)
			end
		end
		
	end},
    {302,function()
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1.5);
		a:x(-100);
		a:y(100);
		a:decelerate(0.5);
		a:x(SCREEN_CENTER_X-128);
		a:rotationz(720);
		a:sleep(0.5);
		a:rotationz(0);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(-SCREEN_HEIGHT/2)
		a:sleep(2); a:queuecommand('Done');
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1.5);
		a:x(SCREEN_WIDTH+100);
		a:y(100);
		a:decelerate(0.5);
		a:x(SCREEN_CENTER_X+128);
		a:rotationz(-720);
		a:sleep(0.5);
		a:rotationz(0);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(-SCREEN_HEIGHT/2)
		a:sleep(2); a:queuecommand('Done');
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1.5);
		a:x(-100);
		a:y(SCREEN_BOTTOM-100);
		a:decelerate(0.5);
		a:x(SCREEN_CENTER_X-256);
		a:rotationz(720-180);
		a:sleep(0.5);
		a:rotationz(180);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(SCREEN_HEIGHT/2)
		a:sleep(2); a:queuecommand('Done');
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1.5);
		a:x(SCREEN_WIDTH+100);
		a:y(SCREEN_BOTTOM-100);
		a:decelerate(0.5);
		a:x(SCREEN_CENTER_X+256);
		a:rotationz(-720+180);
		a:sleep(0.5);
		a:rotationz(180);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(SCREEN_HEIGHT/2)
		a:sleep(2); a:queuecommand('Done');
		
		for _,pe in pairs(GAMESTATE:GetEnabledPlayers()) do
			local pn = tonumber(string.match(pe, "[0-9]+"))
			local a   = GetPlayerAF(pn)
			if a then
				a:z(1);
				a:sleep(0.4);
				a:linear(0.1);
				a:x(SCREEN_CENTER_X/2)
				a:x(SCREEN_HEIGHT)
				a:rotationz(8)
				a:linear(0.1);
				a:x(SCREEN_CENTER_X)
				a:rotationz(0)
			end
		end
		
	end},
    {306,function()
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1);
		a:x(-100);
		a:y(100);
		a:decelerate(0.5);
		a:x(SCREEN_CENTER_X-192);
		a:rotationz(720);
		a:sleep(0.5);
		a:rotationz(0);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(-200)
		a:sleep(2); a:queuecommand('Done');
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1);
		a:x(SCREEN_WIDTH+100);
		a:y(100);
		a:decelerate(0.5);
		a:x(SCREEN_CENTER_X+192);
		a:rotationz(-720);
		a:sleep(0.5);
		a:rotationz(0);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(-200)
		a:sleep(2); a:queuecommand('Done');
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1);
		a:x(SCREEN_CENTER_X);
		a:y(-100);
		a:decelerate(0.5);
		a:y(100);
		a:rotationz(-720);
		a:sleep(0.5);
		a:rotationz(0);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(-200)
		a:sleep(2); a:queuecommand('Done');
		
		for _,pe in pairs(GAMESTATE:GetEnabledPlayers()) do
			local pn = tonumber(string.match(pe, "[0-9]+"))
			local a   = GetPlayerAF(pn)
			if a then
				a:z(1);
				a:sleep(0.35);
				a:accelerate(0.15);
				a:x(0.5*SCREEN_CENTER_X)
				if (pn == 2) then
					a:y(SCREEN_CENTER_Y/2)
				end
				a:rotationz(180-8)
				a:decelerate(0.15);
				a:x(SCREEN_CENTER_X)
				if (pn == 2) then
					a:y(SCREEN_CENTER_Y)
				end
				a:rotationz(0)
				a:sleep(0)
				a:rotationz(0)
			end
		end	
    end},
    {310,function()
		
        --bottom right
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1);
		a:x(SCREEN_WIDTH+100);
		a:y(SCREEN_HEIGHT*0.75);
		a:decelerate(0.5);
		a:x(SCREEN_WIDTH-100);
		a:rotationz(720+90);
		a:sleep(0.5);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addx(200)
		a:sleep(2); a:queuecommand('Done');
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1);
		a:x(SCREEN_WIDTH*0.75);
		a:y(SCREEN_HEIGHT+100);
		a:decelerate(0.5);
		a:y(SCREEN_HEIGHT-100);
		a:rotationz(-720+180);
		a:sleep(0.5);
		a:rotationz(180);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(200)
		a:sleep(2); a:queuecommand('Done');

	        --bottom left
            local a = GetNewGaster();
            a:rotationz(0);
            a:zoom(1);
            a:x(-100);
            a:y(SCREEN_HEIGHT*0.75);
            a:decelerate(0.5);
            a:x(100);
            a:rotationz(720+270);
            a:sleep(0.5);
            a:queuecommand('Fire');
            a:sleep(0.5)
            a:accelerate(0.5)
            a:addx(-200)
            a:sleep(2); a:queuecommand('Done');
            
            local a = GetNewGaster();
            a:rotationz(0);
            a:zoom(1);
            a:x(SCREEN_WIDTH*0.20);
            a:y(SCREEN_HEIGHT+100);
            a:decelerate(0.5);
            a:y(SCREEN_HEIGHT-100);
            a:rotationz(-720+180);
            a:sleep(0.5);
            a:rotationz(180);
            a:queuecommand('Fire');
            a:sleep(0.5)
            a:accelerate(0.5)
            a:addy(200)
            a:sleep(2); a:queuecommand('Done');

        --top right
        local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1);
		a:x(SCREEN_WIDTH+100);
		a:y(SCREEN_HEIGHT*0.25);
		a:decelerate(0.5);
		a:x(SCREEN_WIDTH-100);
		a:rotationz(720+90);
		a:sleep(0.5);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addx(200)
		a:sleep(2); a:queuecommand('Done');
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1);
		a:x(SCREEN_WIDTH*0.75);
		a:y(-100);
		a:decelerate(0.5);
		a:y(SCREEN_HEIGHT*0.20);
		a:rotationz(-720);
		a:sleep(0.5);
		a:rotationz(0);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(-200)
		a:sleep(2); a:queuecommand('Done');


        --top left
        local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1);
		a:x(-100);
		a:y(SCREEN_HEIGHT*0.25);
		a:decelerate(0.5);
		a:x(100);
		a:rotationz(720+270);
		a:sleep(0.5);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addx(-200)
		a:sleep(2); 
        a:queuecommand('Done');
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1);
		a:x(SCREEN_WIDTH*0.20);
		a:y(-100);
		a:decelerate(0.5);
		a:y(SCREEN_HEIGHT*0.20);
		a:rotationz(-720);
		a:sleep(0.5);
		a:rotationz(0);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(-200)
		a:sleep(2);
        a:queuecommand('Done');

		for _,pe in pairs(GAMESTATE:GetEnabledPlayers()) do
			local pn = tonumber(string.match(pe, "[0-9]+"))
			local a   = GetPlayerAF(pn)
			if a then
				a:z(1);
				a:sleep(0.35);
				a:accelerate(0.15);
				a:y(SCREEN_CENTER_Y/2)
				a:x(0.5*SCREEN_CENTER_X- ((pn == 1 and 1 or -1)*50))
				a:rotationz(180-8)
				a:decelerate(0.15);
				a:y(SCREEN_CENTER_Y)
				a:x(SCREEN_CENTER_X- ((pn == 1 and 1 or -1)*50))
				a:rotationz(360-15)
				a:sleep(0)
				a:rotationz(0)
			end
		end			

        
    end},
    {314,function()
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1.25);
		a:x(-100);
		a:y(SCREEN_BOTTOM-100);
		a:decelerate(0.5);
		a:x(SCREEN_CENTER_X-112);
		a:rotationz(720-180);
		a:sleep(0.5);
		a:rotationz(180);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(200)
		a:sleep(2); a:queuecommand('Done');
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1.25);
		a:x(SCREEN_WIDTH+100);
		a:y(SCREEN_BOTTOM-100);
		a:decelerate(0.5);
		a:x(SCREEN_CENTER_X+112);
		a:rotationz(-720+180);
		a:sleep(0.5);
		a:rotationz(180);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(200)
		a:sleep(2); a:queuecommand('Done');
		for _,pe in pairs(GAMESTATE:GetEnabledPlayers()) do
			local pn = tonumber(string.match(pe, "[0-9]+"))
			local a   = GetPlayerAF(pn)
			if a then
				a:z(1);
				a:sleep(0.35);
				a:accelerate(0.15);
				a:y(pn == 1 and P1ypos/2 or P2ypos/2)
				a:x(pn == 1 and 1.5*P1xpos/2 or 1.5*P2xpos/2)
				a:rotationz(180-8)
				a:decelerate(0.15);
				a:y(pn == 1 and P1ypos or P2ypos)
				a:x(pn == 1 and 1.10*P1xpos or 1.10*P2xpos)
				a:rotationz(360-15)
				a:sleep(0)
				a:rotationz(0)
			end
		end	
	end},
    {318,function()
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1.5);
		a:x(-100);
		a:y(-100);
		a:decelerate(0.5);
		a:x(SCREEN_WIDTH*0.20);
        a:y(SCREEN_HEIGHT*0.20);
		a:rotationz(720-45);
		a:sleep(0.5);
		a:rotationz(-45);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(-200)
        a:addx(-200)
		a:sleep(2); a:queuecommand('Done');
		
		local a = GetNewGaster();
		a:rotationz(0);
		a:zoom(1.5);
		a:x(SCREEN_WIDTH+100);
		a:y(-100);
		a:decelerate(0.5);
		a:x(SCREEN_WIDTH*0.75);
        a:y(SCREEN_HEIGHT*0.20);
		a:rotationz(720+45);
		a:sleep(0.5);
		a:rotationz(45);
		a:queuecommand('Fire');
		a:sleep(0.5)
		a:accelerate(0.5)
		a:addy(-200)
        a:addx(200)
		a:sleep(2); a:queuecommand('Done');
		for _,pe in pairs(GAMESTATE:GetEnabledPlayers()) do
			local pn = tonumber(string.match(pe, "[0-9]+"))
			local a   = GetPlayerAF(pn)
			if a then
				a:z(1);
				a:sleep(0.35);
				a:accelerate(0.15);
				a:y(pn == 1 and P1ypos or P2ypos)
				a:x(pn == 1 and P1xpos or P2xpos)
			end
		end	
	end},
		
}

-- Messages to be applied, Number denotes the Mission these messages go off for.
local messages1 = {

    {123.7, 'Dance'},
    {127, 'Pokeball'},
    {128.5,'Spawn',true},
	{129.5,'Spawn2',true},
    {129, 'SpawnAdan'},
    {130, 'Shoot'},
	{131, 'ShowMoney'},
    {134, 'Shoot'},
    {138, 'Shoot'},
    {142, 'Shoot'},
    {146, 'Shoot'},
    {150, 'Shoot'},
    {154, 'Shoot'},
    {158, 'Shoot'},
    {162, 'Hurt'},
    {162.01, 'RedFlash'},
	{188.7, 'Dance'},
    {192, 'Pokeball'},
	{192, 'Spawn3'},
	{193.5,'Spawn',true},
	{193.5,'PurpleFlash'},
    {193.5, 'SoulMaster'},
	{195.3, 'Stretch2'},
	{203.3, 'Stretch'},
	{211.3, 'Stretch3'},
	{219.3, 'Stretch'},
	{227.3, 'Stretch4'},
	{235.3, 'Stretch5'},
	{243.3, 'Stretch3'},

	{200, 'RandomSound2'},

    {240, 'BlastOff'},
	{246, 'Moist'},
	{289.5,'StartBreaking'},
    {289.5,'FireBlaster'},
	{293.5,'FireBlaster'},
    {297.5,'FireBlaster'},
    {301.5,'FireBlaster'},
    {305.5,'FireBlaster'},
    {309.5,'FireBlaster'},
    {313.5,'FireBlaster'},
    {317.5,'FireBlaster'},
	{352, 'GoSuperSaiyan'},

	{420, 'Collect'},
	{422.5, 'CollectPreEnd'},
	{424, 'Flash'},
	{424, 'CollectEnd'},
	{424, 'PVZ'},
	{439, 'Saved'}

}

local changes = {}

local function setChanges()
    changes = dialogue1
    messages = messages1
    mods = mods1
    bigImages = true
    -- sort the messages by beat number (first index) just in case
    table.sort(messages, function(m1, m2) return m1[1] < m2[1] end)
    table.sort(dialogue1, function(m1, m2) return m1[1] < m2[1] end)

end

local SlightFade = function(alpha)
    for player in ivalues(GAMESTATE:GetHumanPlayers()) do

        -- Get the player ActorFrame on ScreenGameplay.
        -- It's a direct child of the screen and named "PlayerP1" for P1
        -- and "PlayerP2" for P2.  This is currently hardcoded in the SM5 engine.
        --
        -- note: ScreenEdit does not name its notefield actor and I don't
        --       know how to get a reference to it from Lua.
        local name = ("Player%s"):format(ToEnumShortString(player))

        -- get a reference to the player ActorFrame
        local player_af = SCREENMAN:GetTopScreen():GetChild(name)

        -- if the player ActorFrame was found (it won't be in Edit Mode)
        if player_af then
            -- Get specificially the NoteField out of the player ActorFrame.
            -- It is a named child ("NoteField"), hardcoded in the SM5 engine.
            local notefield = player_af:GetChild("NoteField")

            -- if the notefield was found (it should be, but hey)
            if notefield then

                -- for each column in the NoteField
                -- there are 4 columns in dance single, 8 in dance double, 5 in pump single, etc.
                for i, column in ipairs(notefield:get_column_actors()) do
                    column:diffusealpha(alpha)
                end
            end
        end
    end
end

local function Handler_mod_internal(str, pn) -- Applies Players options to not be disabled-
    local ps = GAMESTATE:GetPlayerState(pn)
    local pmods = ps:GetPlayerOptionsString('ModsLevel_Song')
    ps:SetPlayerOptions('ModsLevel_Song', pmods .. ', ' .. str)
    -- GAMESTATE:ApplyGameCommand('mod,'..str, pn)
end

local function Handler_mod(str) -- Looks for many players are on the screen
    for i = 1, 2 do Handler_mod_internal(str, 'PlayerNumber_P' .. i) end
end

local function Handler_init() -- Useful for command shorcuts
    if GetPlayerAF(1) then
        P1 =  GetPlayerAF(1)
		if P1 then
			P1xpos=P1:GetX();
			P1ypos=P1:GetY();
		end
    end
    if GetPlayerAF(2) then
        P2 = GetPlayerAF(2)
		if P2 then
			P2xpos=P2:GetX();
			P2ypos=P2:GetY();
		end
    end
    if SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P1Score') then
        P1Score = SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild(
                      'P1Score')
    end
    if SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild('P2Score') then
        P2Score = SCREENMAN:GetTopScreen():GetChild('Underlay'):GetChild(
                      'P2Score')
    end

    fgcurcommand = 0;
    wndr_skewx = 0.3;
    checked = false;

    curmod = 1;
    -- {beat,'mod'},
    mods = {}
    -- SCREAMING GUMBALL / timed message broadcaster
    curmessage = 1;
    -- {beat,message,ignoreIfAhead}
    messages = {}
    setChanges()

end
local counter = 1

local function Handler_update() -- Updates the command to look for the players at the start of the song.

    if GAMESTATE:GetSongBeat() >= 0.1 and not checked then

        screen = SCREENMAN:GetTopScreen()
		if SCREENMAN:GetTopScreen():GetChild('LifeP1') then LifeP1 = SCREENMAN:GetTopScreen():GetChild('LifeP1') end
		if SCREENMAN:GetTopScreen():GetChild('LifeP2') then LifeP2 = SCREENMAN:GetTopScreen():GetChild('LifeP2') end
		if SCREENMAN:GetTopScreen():GetChild('ScoreP1') then ScoreP1 = SCREENMAN:GetTopScreen():GetChild('ScoreP1') end
		if SCREENMAN:GetTopScreen():GetChild('ScoreP2') then ScoreP2 = SCREENMAN:GetTopScreen():GetChild('ScoreP2') end
		if SCREENMAN:GetTopScreen():GetChild('BPMDisplay') then BPMDisplay = SCREENMAN:GetTopScreen():GetChild('BPMDisplay') end
		if SCREENMAN:GetTopScreen():GetChild('LifeFrame') then LifeFrame = SCREENMAN:GetTopScreen():GetChild('LifeFrame') end
		if SCREENMAN:GetTopScreen():GetChild('ScoreFrame') then ScoreFrame = SCREENMAN:GetTopScreen():GetChild('ScoreFrame') end
		if SCREENMAN:GetTopScreen():GetChild('Lyrics') then Lyrics = SCREENMAN:GetTopScreen():GetChild('Lyrics') end
		if SCREENMAN:GetTopScreen():GetChild('SongForeground') then SongForeground = SCREENMAN:GetTopScreen():GetChild('SongForeground') end
		if SCREENMAN:GetTopScreen():GetChild('SongBackground') then SongBackground = SCREENMAN:GetTopScreen():GetChild('SongBackground') end
		if SCREENMAN:GetTopScreen():GetChild('Overlay') then Overlay = SCREENMAN:GetTopScreen():GetChild('Overlay') end
		if SCREENMAN:GetTopScreen():GetChild('Underlay') then Underlay = SCREENMAN:GetTopScreen():GetChild('Underlay') end
		
		if SCREENMAN:GetTopScreen():GetChild('Debug') then
			SCREENMAN:GetTopScreen():GetChild('Debug'):y(SCREEN_CENTER_Y-900);
		end
        checked = true;

    end
    if changes[counter] and GAMESTATE:GetSongBeat() >= changes[counter][1] then
        changes[counter][2]()
        counter = counter + 1
    end
    local beat = GAMESTATE:GetSongBeat()
    -- SM(beat)
    -- Collect all the mods that will be applied in this frame into one string.
    -- Mod tweening doesn't work correctly if the mods are in seperate commands.
    local mods_this_frame = {}
    local function add_mod(mod_str)
        mods_this_frame[#mods_this_frame + 1] = mod_str
    end
    local function execute_mods()
        if #mods_this_frame <= 0 then return end
        local total_mod_str = ""
        for i, ms in ipairs(mods_this_frame) do
            if #total_mod_str > 0 then
                total_mod_str = total_mod_str .. ", "
            end
            total_mod_str = total_mod_str .. ms
        end
        Handler_mod(total_mod_str)
    end

    while curmod <= #mods and GAMESTATE:GetSongBeat() >= mods[curmod][1] do
        add_mod(mods[curmod][2])
        curmod = curmod + 1
    end

    execute_mods()

    while curmessage <= #messages and GAMESTATE:GetSongBeat() >=
        messages[curmessage][1] do
        if messages[curmessage][3] and GAMESTATE:GetSongBeat() >=
            messages[curmessage][1] + 5 then
            curmessage = curmessage + 1;
        else
            MESSAGEMAN:Broadcast(messages[curmessage][2])
            curmessage = curmessage + 1;
        end
    end
end

local last_score_x = 0
local musicrate = GAMESTATE:GetSongOptionsObject("ModsLevel_Song"):MusicRate()
t[#t+1] = Def.ActorFrame {

    OnCommand = function(self)
        Handler_init()
        self:SetUpdateFunction(Handler_update)

        -- ---------------------
        -- hide ScreenGameplay's "in" layer,
        -- which typically has a text overlay for
        -- "EVENT MODE" or "STAGE 1" or similar
        local screen = SCREENMAN:GetTopScreen()
        if screen then
            local GameplayIn_layer = screen:GetChild("In")
            if GameplayIn_layer then GameplayIn_layer:visible(false) end
        end
        -- ---------------------
    end,
	ShootMessageCommand= function(self)
		--SM("FIRE!")
		createMissileExplosion(3*SCREEN_WIDTH/4, SCREEN_CENTER_Y)
		if activeBugattis < bugatti then
			bugattis[activeBugattis]:queuecommand("ShootBugatti")
			activeBugattis = activeBugattis + 1
		end
	end,
    Def.Quad {
        Name = "I may be sleeping, but I preserve the world.",
        InitCommand = cmd(visible, false),
        OnCommand = cmd(sleep, 1000)
    },
	LoadActor("HollowPalace.mp4")..{
		InitCommand= function(self)
				self:diffusealpha(0)
				local src_w = self:GetTexture():GetSourceWidth()
				self:FullScreen()
		end,
		SoulMasterMessageCommand=function(self)
			self:sleep(0)
            self:linear(1):diffusealpha(1)
		end,
		BlastOffMessageCommand=function(self)
			self:sleep(10):linear(20):diffusealpha(0)
		end,
	},
    LoadActor("TateBG.jpg")..{
		InitCommand= function(self)
				self:diffusealpha(0)
				local src_w = self:GetTexture():GetSourceWidth()
				self:FullScreen()
		end,
		BlastOffMessageCommand=function(self)
			self:sleep(10)
            self:linear(20):diffusealpha(1)
		end,
	},
	LoadActor("TateBG2.jpg")..{
		InitCommand= function(self)
				self:diffusealpha(0)
				local src_w = self:GetTexture():GetSourceWidth()
				self:FullScreen()
		end,
		GoSuperSaiyanMessageCommand=function(self)
            self:sleep(0.5):diffusealpha(1)
		end,
	},
	Def.ActorFrame{ OnCommand=cmd(y,-200), PokeballMessageCommand=cmd(playcommand,"Go";y,-200;accelerate,2*(60/174);y,0), 
    LoadActor("pokeball")..{ OnCommand=cmd(x,SCREEN_WIDTH+100;y,SCREEN_HEIGHT*0.8),
    GoCommand=cmd(zoom,1;diffusealpha,1;rotationz,0;x,SCREEN_WIDTH+100;
    linear,2*(60/174);x,SCREEN_WIDTH*0.25;rotationz,720;sleep,0;decelerate,0.6;zoom,1.5;diffusealpha,0),
    },
    -- Def.ActorFrame{ OnCommand=cmd(y,-200), PokeballMessageCommand=cmd(playcommand,"Go";y,-200;accelerate,2*(60/174);y,0), 
    -- LoadActor("luxurypokeball.png")..{ OnCommand=cmd(zoom,0.175;x,SCREEN_WIDTH+100;y,SCREEN_HEIGHT*0.8),
    -- GoCommand=cmd(zoom,0.175;diffusealpha,1;rotationz,0;x,SCREEN_WIDTH+100;
    -- linear,2*(60/174);x,SCREEN_WIDTH*0.25;rotationz,720;sleep,0;decelerate,0.6;zoom,0.175*1.5;diffusealpha,0),
    -- },
    Def.Quad{
        OnCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,0,0,0,0),
        WhiteFlashLongMessageCommand=cmd(diffuse,1,1,1,1;linear,3;diffusealpha,0),
		PurpleFlashMessageCommand=cmd(diffuse,Color.Black;linear,0.6;diffusealpha,0),
		StretchMessageCommand=cmd(accelerate,0.25;diffuse,0,0,0,1;linear,1;diffusealpha,0),
		Stretch2MessageCommand=cmd(accelerate,0.25;diffuse,0,0,0,1;linear,1;diffusealpha,0),
		Stretch3MessageCommand=cmd(accelerate,0.25;diffuse,0,0,0,1;linear,1;diffusealpha,0),
		Stretch4MessageCommand=cmd(accelerate,0.25;diffuse,0,0,0,1;linear,1;diffusealpha,0),
		Stretch5MessageCommand=cmd(accelerate,0.25;diffuse,0,0,0,1;linear,1;diffusealpha,0),

        WhiteFlashMessageCommand=cmd(diffuse,1,1,1,1;linear,1;diffusealpha,0),
        RedFlashMessageCommand=cmd(diffuse,1,0,0,1;linear,1;diffusealpha,0),
        RedFlashQMessageCommand=cmd(diffuse,1,0,0,0.6;linear,0.6;diffusealpha,0),
        },
    },
    Def.ActorFrame{ HurtMessageCommand=cmd(
        sleep,0.08;x,-20;sleep,0.08;x,20;sleep,0.08;x,-20;sleep,0.08;x,20;
        sleep,0.08;x,-10;sleep,0.08;x,10;sleep,0.08;x,-10;sleep,0.08;x,10;
        sleep,0.08;x,-5;sleep,0.08;x,5;sleep,0.08;x,-5;sleep,0.08;x,5;
        sleep,0.08;x,-3;sleep,0.08;x,3;sleep,0.08;x,-3;sleep,0.08;x,3;
        sleep,0.08;x,0;),
        Def.Sprite{
            Texture ='Adin 3x2.png';
            InitCommand = function(self) tateo= self; end;
            Spawn2MessageCommand=cmd(visible,true;bounceend,0.3;zoom,0.37;glow,1,1,1,0),
            OnCommand=cmd(visible,false;vertalign,bottom;glow,1,1,1,1;zoomx,0;zoomy,1;x,SCREEN_WIDTH*0.25;y,SCREEN_HEIGHT;
            croptop,0.005;cropright,0.005;cropbottom,0.005;cropleft,0.005),
            DanceMessageCommand= function(self)
                self:SetStateProperties( adanFrames["Talking"] ):loop(true):animate(true)
            end,
            ShootMessageCommand=function(self)
                self:SetStateProperties( adanFrames["Shooting"] )
                self:loop(false):bounce():effectmagnitude(4,1,0):effectperiod(0.2)
            end,
            HurtMessageCommand=function(self)
                self:SetStateProperties( adanFrames["Lose"] ):setstate(0):animate(false)
                self:stopeffect():zoom(0.3):linear(2):diffusealpha(0)
            end
        }
    },

	Def.ActorFrame{ OnCommand=cmd(x,SCREEN_WIDTH*0.25;y,SCREEN_HEIGHT*0.8;zoom,0.6),
		Def.ActorFrame{ OnCommand=cmd(zoom,2.5;spin;effectmagnitude,0,0,90;),
			LoadActor("casting")..{
			OnCommand=cmd(blend,"add";diffuse,1,0.2,1,0),
			SpawnMessageCommand=function (self)
				self:zoom(1.1);
				self:linear(0.8);
				self:diffusealpha(1);
				self:linear(1);
				self:zoom(0.7);
				self:linear(0.8);
				self:diffusealpha(0);
				self:zoom(0.5);
			end, },
		},
		
		Def.ActorFrame{ SpawnMessageCommand=function(self) self:playcommand('Inner'); chara_drand = math.random(0,360);
		chara_dspd = (math.random(0,600)/100)-3; self:playcommand('Turn') end,
		TurnCommand=cmd(rotationz,chara_drand;
		linear,0.1;rotationz,chara_drand+(60*chara_dspd);
		linear,0.1;rotationz,chara_drand+(110*chara_dspd);
		linear,0.1;rotationz,chara_drand+(150*chara_dspd);
		linear,0.1;rotationz,chara_drand+(180*chara_dspd);
		linear,0.2;rotationz,chara_drand+(200*chara_dspd);
		linear,1.0;rotationz,chara_drand+(350*chara_dspd);
		linear,0.2;rotationz,chara_drand+(370*chara_dspd);
		linear,0.2;rotationz,chara_drand+(400*chara_dspd);
		linear,0.2;rotationz,chara_drand+(440*chara_dspd);
		linear,0.2;rotationz,chara_drand+(490*chara_dspd);
		linear,0.2;rotationz,chara_drand+(550*chara_dspd)),
		
		LoadActor("triangle")..{
		OnCommand=cmd(vertalign,top;blend,"add";diffusealpha,0;fadetop,0.2;fadebottom,0.2;
		diffuseblink;effectcolor1,0,1,0.2,0.3;effectcolor2,0,1,0.2,1;effectperiod,0.066),
		InnerCommand=cmd(zoom,1;diffusealpha,0;linear,0.5;diffusealpha,1;zoomy,5;zoomx,3;linear,1.5;
		zoomy,8;zoomx,3;linear,0.6;zoomy,20;zoomx,0;sleep,0;diffusealpha,0),
		Spawn3MessageCommand=cmd(diffuseblink;effectcolor1,1,0,0.2,0.3;effectcolor2,1,0,0.2,1;effectperiod,0.066);
		},
		},
		Def.ActorFrame{ SpawnMessageCommand=function(self) self:playcommand('Inner'); chara_drand = math.random(0,360);
		chara_dspd = (math.random(0,600)/100)-3; self:playcommand('Turn') end,
		TurnCommand=cmd(rotationz,chara_drand;
		linear,0.1;rotationz,chara_drand+(60*chara_dspd);
		linear,0.1;rotationz,chara_drand+(110*chara_dspd);
		linear,0.1;rotationz,chara_drand+(150*chara_dspd);
		linear,0.1;rotationz,chara_drand+(180*chara_dspd);
		linear,0.2;rotationz,chara_drand+(200*chara_dspd);
		linear,1.0;rotationz,chara_drand+(350*chara_dspd);
		linear,0.2;rotationz,chara_drand+(370*chara_dspd);
		linear,0.2;rotationz,chara_drand+(400*chara_dspd);
		linear,0.2;rotationz,chara_drand+(440*chara_dspd);
		linear,0.2;rotationz,chara_drand+(490*chara_dspd);
		linear,0.2;rotationz,chara_drand+(550*chara_dspd)),
		
		LoadActor("triangle")..{
		OnCommand=cmd(vertalign,top;blend,"add";diffusealpha,0;fadetop,0.2;fadebottom,0.2;
		diffuseblink;effectcolor1,0,1,0.2,0.3;effectcolor2,0,1,0.2,1;effectperiod,0.066),
		InnerCommand=cmd(zoom,1;diffusealpha,0;linear,0.5;diffusealpha,1;zoomy,5;zoomx,3;linear,1.5;
		zoomy,8;zoomx,3;linear,0.6;zoomy,20;zoomx,0;sleep,0;diffusealpha,0),
		Spawn3MessageCommand=cmd(diffuseblink;effectcolor1,1,0,0.2,0.3;effectcolor2,1,0,0.2,1;effectperiod,0.066);
		},
		},
		Def.ActorFrame{ SpawnMessageCommand=function(self) self:playcommand('Inner'); chara_drand = math.random(0,360);
		chara_dspd = (math.random(0,600)/100)-3; self:playcommand('Turn') end,
		TurnCommand=cmd(rotationz,chara_drand;
		linear,0.1;rotationz,chara_drand+(60*chara_dspd);
		linear,0.1;rotationz,chara_drand+(110*chara_dspd);
		linear,0.1;rotationz,chara_drand+(150*chara_dspd);
		linear,0.1;rotationz,chara_drand+(180*chara_dspd);
		linear,0.2;rotationz,chara_drand+(200*chara_dspd);
		linear,1.0;rotationz,chara_drand+(350*chara_dspd);
		linear,0.2;rotationz,chara_drand+(370*chara_dspd);
		linear,0.2;rotationz,chara_drand+(400*chara_dspd);
		linear,0.2;rotationz,chara_drand+(440*chara_dspd);
		linear,0.2;rotationz,chara_drand+(490*chara_dspd);
		linear,0.2;rotationz,chara_drand+(550*chara_dspd)),
		
		LoadActor("triangle")..{
		OnCommand=cmd(vertalign,top;blend,"add";diffusealpha,0;fadetop,0.2;fadebottom,0.2;
		diffuseblink;effectcolor1,1,1,0.2,0.3;effectcolor2,0,1,0.2,1;effectperiod,0.066),
		InnerCommand=cmd(zoom,1;diffusealpha,0;linear,0.5;diffusealpha,1;zoomy,5;zoomx,3;linear,1.5;
		zoomy,8;zoomx,3;linear,0.6;zoomy,20;zoomx,0;sleep,0;diffusealpha,0),
		Spawn3MessageCommand=cmd(diffuseblink;effectcolor1,1,0,0.2,0.3;effectcolor2,1,0,0.2,1;effectperiod,0.066);
		},
		},
		Def.ActorFrame{ SpawnMessageCommand=function(self) self:playcommand('Inner'); chara_drand = math.random(0,360);
		chara_dspd = (math.random(0,600)/100)-3; self:playcommand('Turn') end,
		TurnCommand=cmd(rotationz,chara_drand;
		linear,0.1;rotationz,chara_drand+(60*chara_dspd);
		linear,0.1;rotationz,chara_drand+(110*chara_dspd);
		linear,0.1;rotationz,chara_drand+(150*chara_dspd);
		linear,0.1;rotationz,chara_drand+(180*chara_dspd);
		linear,0.2;rotationz,chara_drand+(200*chara_dspd);
		linear,1.0;rotationz,chara_drand+(350*chara_dspd);
		linear,0.2;rotationz,chara_drand+(370*chara_dspd);
		linear,0.2;rotationz,chara_drand+(400*chara_dspd);
		linear,0.2;rotationz,chara_drand+(440*chara_dspd);
		linear,0.2;rotationz,chara_drand+(490*chara_dspd);
		linear,0.2;rotationz,chara_drand+(550*chara_dspd)),
		
		LoadActor("triangle")..{
		OnCommand=cmd(vertalign,top;blend,"add";diffusealpha,0;fadetop,0.2;fadebottom,0.2;
		diffuseblink;effectcolor1,0,1,0.2,0.3;effectcolor2,0,1,0.2,1;effectperiod,0.066),
		InnerCommand=cmd(zoom,1;diffusealpha,0;linear,0.5;diffusealpha,1;zoomy,5;zoomx,3;linear,1.5;
		zoomy,8;zoomx,3;linear,0.6;zoomy,20;zoomx,0;sleep,0;diffusealpha,0),
		Spawn3MessageCommand=cmd(diffuseblink;effectcolor1,1,0,0.2,0.3;effectcolor2,1,0,0.2,1;effectperiod,0.066);
		},
		},
		
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if P1Score and not isEditMode() then
				self:SetTarget(P1Score)
			end
		end
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if P2Score and not isEditMode() then
				self:SetTarget(P2Score)
			end
		end
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if IsEditMode() then
				P1=GetPlayerAF("P1")
				self:SetTarget(P1)
			else
				self:SetTarget(P1)
			end
		end
	},
	LoadActor("HolyTate.png")..{
		InitCommand= function(self)
				self:visible(false)
				local src_w = self:GetTexture():GetSourceWidth()
				self:Center():zoom(0.6):y(1000)
		end,
		BlastOffMessageCommand=function(self)
			self:visible(true):vibrate():effectmagnitude(4,0,1):linear(24):y(6*SCREEN_HEIGHT/10)
            self:queuecommand("StopVibrate")
		end,
        StopVibrateCommand=function(self)
            self:stopeffect()
        end,
        FireBlasterMessageCommand=function(self)
			self:bounce():effectmagnitude(0,0,100):effectperiod(1)
			self:sleep(1.5):vibrate():effectmagnitude(4,0,1)
			self:sleep(0.3):queuecommand("StopVibrate")
        end,
		StartBreakingMessageCommand=function(self)
			self:sleep(3):linear(15):diffusealpha(0):queuecommand("Boom")
        end,
		BoomCommand=function(self)
			MESSAGEMAN:Broadcast("WhiteFlash")
			self:diffusealpha(0):linear(5):addrotationz(180):addy(500)
		end
	},
	LoadActor("HolyTateBroke.png")..{
		InitCommand= function(self)
				self:visible(false)
				local src_w = self:GetTexture():GetSourceWidth()
				self:Center():zoom(0.6):y(1000):diffusealpha(0)
		end,
		BlastOffMessageCommand=function(self)
			self:visible(false):vibrate():effectmagnitude(4,0,1):linear(24):y(6*SCREEN_HEIGHT/10)
            self:queuecommand("StopV`	ibrate")
		end,
        StopVibrateCommand=function(self)
            self:stopeffect()
        end,
		FireBlasterMessageCommand=function(self)
			self:bounce():effectmagnitude(0,0,100):effectperiod(1)
			self:sleep(1.5):vibrate():effectmagnitude(4,0,1)
			self:sleep(0.3):queuecommand("StopVibrate")
        end,
        StartBreakingMessageCommand=function(self)
			self:visible(true):sleep(3):diffusealpha(0):linear(15):diffusealpha(1):playcommand("Boom")
        end,
		BoomCommand=function(self)
			self:linear(5):addrotationz(180):addy(1000)
		end
	},
	Def.ActorProxy {
		OnCommand = function(self)
			self:queuecommand('Set')
		end,
		SetCommand = function(self)
			if IsEditMode() then
				self:SetTarget(GetPlayerAF("P1"))
				P2 = self
			elseif P2 then
				self:SetTarget(P2)
			end	
		end
	},
	Def.Quad {
		InitCommand=function(self)
			self:FullScreen():diffuse(Color.White):diffusealpha(0)
		end,
		GoSuperSaiyanMessageCommand=function(self)
			DoSound("SaiyanNoise")
			self:accelerate(0.6):diffusealpha(1):decelerate(2):diffusealpha(0)
		end,
	},

    Def.Sound{
		File="sounds/spell.ogg",
		SpawnAdanMessageCommand=function(self)
			 self:play() 
		end,
		SoulMasterMessageCommand=function(self)
			self:stop():play() 
	   end
	},
	-- Def.Sound{
	-- 	File="sounds/OneHand.ogg",
	-- 	RandomSoundMessageCommand=function(self)
	-- 		 self:play() 
	-- 	end
	-- },
	-- Def.Sound{
	-- 	File="sounds/HARAM.ogg",
	-- 	RandomSoundMessageCommand=function(self)
	-- 		 self:play() 
	-- 	end
	-- },
	-- Def.Sound{
	-- 	File="sounds/Bugatti.ogg",
	-- 	RandomSoundMessageCommand=function(self)
	-- 		if math.random()*10 > 8 then
	-- 			self:play() 
	-- 		end
	-- 	end
	-- },
	-- Def.Sound{
	-- 	File="sounds/BreathAir.ogg",
	-- 	RandomSound2MessageCommand=function(self)
	-- 		 self:play() 
	-- 	end
	-- },
    Def.Sprite{
		Frames = {												
            {Frame= 32, Delay= 0.066},
            {Frame= 33, Delay= 0.066},
            {Frame= 34, Delay= 0.066},
            {Frame= 35, Delay= 0.066},
            {Frame= 36, Delay= 0.066},
            {Frame= 37, Delay= 0.066},
            {Frame= 38, Delay= 0.066},
            {Frame= 39, Delay= 0.066},
            {Frame= 40, Delay= 0.066},
            {Frame= 41, Delay= 0.066},
            {Frame= 42, Delay= 0.066},
            {Frame= 43, Delay= 0.066},
            {Frame= 44, Delay= 0.066},
            {Frame= 45, Delay= 0.066},
            {Frame= 46, Delay= 0.066},
            {Frame= 47, Delay= 0.066},
            {Frame= 48, Delay= 0.066},
            {Frame= 49, Delay= 0.066},
            {Frame= 50, Delay= 0.066},
            {Frame= 51, Delay= 0.066},
            {Frame= 52, Delay= 0.066},
            {Frame= 53, Delay= 0.066},
            {Frame= 54, Delay= 0.066},
            {Frame= 55, Delay= 0.066},
            {Frame= 56, Delay= 0.066},
            {Frame= 57, Delay= 0.066},
            {Frame= 58, Delay= 0.066},
            {Frame= 59, Delay= 0.066},
            {Frame= 60, Delay= 0.066},
            {Frame= 61, Delay= 0.066},
		};
		Texture ='dancing-tate 8x8.png';
		InitCommand = function(self) tateo= self; end;
		OnCommand = function(self)
			self:visible(false):Center():x(SCREEN_WIDTH+180):zoom(0.5):addy(-50)
            self:rotationy(180):animate(false):setstate(25)
		end,
		DanceMessageCommand= function(self)
            self:visible(true)
			self:sleep(0.5):accelerate(0.5):addx(-125)
			self:linear(0.10):addx(-25):queuecommand("Move")
			self:linear(0.5):addx(-125)
			self:sleep(0.75):queuecommand("StopMoving");
            self:decelerate(1.5):addx(300)
		end,
		StopMovingCommand=function(self)
			self:animate(false):setstate(25)
		end,
		MoveCommand=function(self)
			self:sleep(0.5):animate(true):SetAllStateDelays(0.04)
		end,
	},
    LoadActor( "chara" )..{
		ZTopMessageCommand=cmd(z,10),
	},
	LoadActor("Money.mp4")..{
		InitCommand=function(self)
			self:FullScreen():diffusealpha(0)
		end,
		ShowMoneyMessageCommand=function(self)
			self:linear(7):diffusealpha(1):blend('BlendMode_Add')
		end,
		StretchMessageCommand=function(self)
			self:linear(3):diffusealpha(0)
			DoSound('Rock')
		end,
		Stretch1MessageCommand=function(self)
			DoSound('Rock')
		end,
		Stretch2MessageCommand=function(self)
			DoSound('Rock')
			self:visible(false)
		end,
		Stretch3MessageCommand=function(self)
			DoSound('Rock')
		end,
		Stretch4MessageCommand=function(self)
			DoSound('Rock')
		end,
		Stretch5MessageCommand=function(self)
			DoSound('Rock')
		end,
	},
	Def.Sprite{
	Texture='../lua/Goam 4x2.png',
	InitCommand=function(self)
		self:Center():zoom(1):SetAllStateDelays(0.1):setstate(3):animate(false)
	end,
	StretchMessageCommand=function(self)
		self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
	end,
	Stretch5MessageCommand=function(self)
		self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
	end,
	IdleCommand=function(self)
		self:SetStateProperties( Frames.Idle ):SetAllStateDelays(0.1)
		self:sleep(1.5):queuecommand('Reverse')
	end,
	ReverseCommand=function(self)
		self:SetStateProperties( Frames.Reverse ):SetAllStateDelays(0.1)
		self:sleep(0.8):queuecommand('Hide')
	end,
	HideCommand=function(self)
		self:animate(false)
	end
	},
	Def.Sprite{
		Texture='../lua/Goam 4x2.png',
		InitCommand=function(self)
			self:x(0):y(SCREEN_HEIGHT/4):zoom(1):SetAllStateDelays(0.1):setstate(3):animate(false)
			self:rotationz(180)
		end,
		StretchMessageCommand=function(self)
			self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
		end,
		IdleCommand=function(self)
			self:SetStateProperties( Frames.Idle ):SetAllStateDelays(0.1)
			self:sleep(1.5):queuecommand('Reverse')
		end,
		ReverseCommand=function(self)
			self:SetStateProperties( Frames.Reverse ):SetAllStateDelays(0.1)
			self:sleep(0.8):queuecommand('Hide')
		end,
		HideCommand=function(self)
			self:animate(false)
		end
	},
	Def.Sprite{
		Texture='../lua/Goam 4x2.png',
		InitCommand=function(self)
			self:zoom(0.85):x(50):y(2*SCREEN_HEIGHT/4):SetAllStateDelays(0.1):setstate(3):animate(false)
			self:rotationz(90)
		end,

		Stretch4MessageCommand=function(self)
			self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
		end,
		Stretch2MessageCommand=function(self)
			self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
		end,
		IdleCommand=function(self)
			self:SetStateProperties( Frames.Idle ):SetAllStateDelays(0.1)
			self:sleep(1.5):queuecommand('Reverse')
		end,
		ReverseCommand=function(self)
			self:SetStateProperties( Frames.Reverse ):SetAllStateDelays(0.1)
			self:sleep(0.8):queuecommand('Hide')
		end,
		HideCommand=function(self)
			self:animate(false)
		end
	},
	Def.Sprite{
		Texture='../lua/Goam 4x2.png',
		InitCommand=function(self)
			self:zoom(0.85):x(SCREEN_WIDTH-50):y(2*SCREEN_HEIGHT/4):SetAllStateDelays(0.1):setstate(3):animate(false)
			self:rotationz(-90)
		end,
		Stretch2MessageCommand=function(self)
			self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
		end,
		Stretch4MessageCommand=function(self)
			self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
		end,
		IdleCommand=function(self)
			self:SetStateProperties( Frames.Idle ):SetAllStateDelays(0.1)
			self:sleep(1.5):queuecommand('Reverse')
		end,
		ReverseCommand=function(self)
			self:SetStateProperties( Frames.Reverse ):SetAllStateDelays(0.1)
			self:sleep(0.8):queuecommand('Hide')
		end,
		HideCommand=function(self)
			self:animate(false)
		end
	},
	Def.Sprite{
		Texture='../lua/Goam 4x2.png',
		InitCommand=function(self)
			self:x(SCREEN_WIDTH):y(SCREEN_HEIGHT/4):zoom(1):SetAllStateDelays(0.1):setstate(3):animate(false)
			self:rotationz(180)
		end,
		StretchMessageCommand=function(self)
			self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
		end,
		IdleCommand=function(self)
			self:SetStateProperties( Frames.Idle ):SetAllStateDelays(0.1)
			self:sleep(1.6):queuecommand('Reverse')
		end,
		ReverseCommand=function(self)
			self:SetStateProperties( Frames.Reverse ):SetAllStateDelays(0.1)
			self:sleep(0.8):queuecommand('Hide')

		end,
		HideCommand=function(self)
			self:animate(false)
		end
	},
	Def.Sprite{
		Texture='../lua/Goam 4x2.png',
		InitCommand=function(self)
			self:x(0):y(0):zoom(1):SetAllStateDelays(0.1):setstate(3):animate(false)
			self:rotationz(90+45)
		end,
		Stretch3MessageCommand=function(self)
			self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
		end,
		Stretch5MessageCommand=function(self)
			self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
		end,
		IdleCommand=function(self)
			self:SetStateProperties( Frames.Idle ):SetAllStateDelays(0.1)
			self:sleep(1.6):queuecommand('Reverse')
		end,
		ReverseCommand=function(self)
			self:SetStateProperties( Frames.Reverse ):SetAllStateDelays(0.1)
			self:sleep(0.8):queuecommand('Hide')
		end,
		HideCommand=function(self)
			self:animate(false)
		end
	},
	Def.Sprite{
		Texture='../lua/Goam 4x2.png',
		InitCommand=function(self)
			self:x(SCREEN_WIDTH):y(0):zoom(1):SetAllStateDelays(0.1):setstate(3):animate(false)
			self:rotationz(-90-45)
		end,
		Stretch3MessageCommand=function(self)
			self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
		end,
		
		Stretch4MessageCommand=function(self)
			self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
		end,
		IdleCommand=function(self)
			self:SetStateProperties( Frames.Idle ):SetAllStateDelays(0.1)
			self:sleep(1.6):queuecommand('Reverse')
		end,
		ReverseCommand=function(self)
			self:SetStateProperties( Frames.Reverse ):SetAllStateDelays(0.1)
			self:sleep(0.8):queuecommand('Hide')
		end,
		HideCommand=function(self)
			self:animate(false)
		end
	},
	Def.Sprite{
		Texture='../lua/Goam 4x2.png',
		InitCommand=function(self)
			self:x(SCREEN_WIDTH):y(SCREEN_HEIGHT):zoom(1):SetAllStateDelays(0.1):setstate(3):animate(false)
			self:rotationz(-45)
		end,
		Stretch5MessageCommand=function(self)
			self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
		end,
		Stretch3MessageCommand=function(self)
			self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
		end,
		IdleCommand=function(self)
			self:SetStateProperties( Frames.Idle ):SetAllStateDelays(0.1)
			self:sleep(1.6):queuecommand('Reverse')
		end,
		ReverseCommand=function(self)
			self:SetStateProperties( Frames.Reverse ):SetAllStateDelays(0.1)
			self:sleep(0.8):queuecommand('Hide')

		end,
		HideCommand=function(self)
			self:animate(false)
		end
	},
	Def.Sprite{
		Texture='../lua/Goam 4x2.png',
		InitCommand=function(self)
			self:x(0):y(SCREEN_HEIGHT):zoom(1):SetAllStateDelays(0.1):setstate(3):animate(false)
			self:rotationz(45)
		end,

		Stretch3MessageCommand=function(self)
			self:animate(true):SetAllStateDelays(0.1):sleep(0.5):queuecommand('Idle')
		end,
		IdleCommand=function(self)
			self:SetStateProperties( Frames.Idle ):SetAllStateDelays(0.1)
			self:sleep(1.6):queuecommand('Reverse')
		end,
		ReverseCommand=function(self)
			self:SetStateProperties( Frames.Reverse ):SetAllStateDelays(0.1)
			self:sleep(0.8):queuecommand('Hide')

		end,
		HideCommand=function(self)
			self:animate(false)
		end
	},
	 
    Def.Sprite{
        Frames = {												
          {Frame=0,Delay=0.541459/6},
          {Frame=1,Delay=0.541459/6},
          {Frame=2,Delay=0.541459/6},
          {Frame=3,Delay=0.541459/6},
          {Frame=4,Delay=0.541459/6},
          {Frame=5,Delay=0.541459/6},
		  {Frame=2,Delay=0.541459/6},

  
        };
        Texture = 'SoulMaster 6x1.png';
        InitCommand = function(self) 
      --    self:visible(false):diffusealpha(0):sleep(75):Center():animate(true):x(3*SCREEN_WIDTH/4):y(3.5*SCREEN_HEIGHT/4):zoom(0.3)
          self:visible(false):Center():zoom(0.5):x(SCREEN_WIDTH*0.25):y(10*SCREEN_HEIGHT/15):diffusealpha(0)
        end,
        SoulMasterMessageCommand=function(self)
            self:visible(true):linear(0.5):diffusealpha(1):linear(1)
			self:bob():effectmagnitude(0,-80,0):queuecommand("RandoPos")
        end,
		RandoPosCommand=function(self)
			if GAMESTATE:GetSongBeat() < 242 then
				if (math.random(0,10) % 4) then
					self:addrotationy(180)
				end
				self:visible(true):decelerate(1.5):x(math.random(10,SCREEN_WIDTH-10)):y(math.random(60, SCREEN_HEIGHT-50)):bob():effectmagnitude(0,-80,0)
				self:sleep(0.5):queuecommand("RandoPos")
			else 
				self:visible(true):decelerate(1.5):Center()
			end
		end,
		MoistMessageCommand=function(self)
			self:rotationy(0):accelerate(0.25):addx(-50)
			self:accelerate(2.5):addx(1000):wag():effectmagnitude(0,0,30):effectperiod(0.75)
		end,
    },
	Def.Sprite{
        Texture = 'Moist.png';
        InitCommand = function(self) 
      --    self:visible(false):diffusealpha(0):sleep(75):Center():animate(true):x(3*SCREEN_WIDTH/4):y(3.5*SCREEN_HEIGHT/4):zoom(0.3)
          self:visible(false):Center():zoom(0.3):x(0)
        end,
        MoistMessageCommand=function(self)
            self:visible(true):spring(0.5):rotationz(45):addx(40)
			self:sleep(2):linear(0.5):rotationz(-45):addx(-300)
        end,
    },
	LoadActor("white.jpg")..{
		InitCommand=function(self)
			self:FullScreen():diffuse(Color.Black)
			self:diffusealpha(0.8):blend(1)
		end,
	},
}

t[#t + 1] = Def.ActorFrame {
	RevealCommand = function(self)
		self:linear(10):addy(-1*_screen.h*0.75)
	end,
	UnvealCommand = function(self)
		self:addy(_screen.h*0.75)
	end,

	Def.Sprite {
		Texture = "Dialog/box.png",
		OnCommand = function(self)
			self:CenterX():y(_screen.h * .85):zoom(.2):diffusealpha(0)
				:SetAllStateDelays(0.15)
			text_actor.box2 = self
			if not bigImages then
				text_actor.box = self
			else
				self:visible(false)
			end
		end,
		ShowCommand = function(self)
			if not bigImages then
				text_actor.box = self
				self:visible(true)
				if cereal then
					self:zoom(0.2):diffusealpha(0.9):linear(.1):zoom(.3)
				end

			else
				self:visible(false)
			end
		end,
		RevealCommand = function(self)
			self:zoom(0.2):diffusealpha(0.9):linear(.1):zoom(.3):linear(12):diffusealpha(0.2)
		end,
		UnvealCommand = function(self)
			self:zoom(0.3):diffusealpha(0.9)
			cereal = true
		end,
		HideBoxMessageCommand = function(self)
			self:zoom(.3):linear(.1):zoom(0.1):diffusealpha(0)
		end,
		HideCommand = function(self)
			self:zoom(.3):linear(.1):zoom(0.1):diffusealpha(0)
		end
	},
	Def.Sprite {
		-- Texture=FILEMAN:DoesFileExist(path..'lua/Dialog/'..person..' 1x3.png') and '../lua/Dialog/'..person..' 1x3.png' or '../lua/Dialog/'..person..' 1x2.png',
		Texture = 'Dialog/Andrew Tate.png',
		OnCommand = function(self)
			self:CenterX():y(_screen.h * .50):zoom(.2):diffusealpha(0)
				:SetAllStateDelays(0.15):visible(true)
			if not bigImages then
				self:align(0.5, 1):xy(_screen.w * .10, _screen.h * .95):zoom(0.1)
			end
			text_actor["Andrew Tate"] = self
		end,
		ShowCommand = function(self)
			box_flag = true
			speaker = "Andrew Tate"
			text_actor.box:queuecommand('Show')
			self:CenterX():zoom(0.2):diffusealpha(0.9):linear(.1):zoom(0.4)
			if not bigImages then
				self:align(0.5, 1):xy(_screen.w * .10, _screen.h * .95):zoom(0.1)
			end
		end,
		HideBoxMessageCommand = function(self)
			box_flag = false
			self:linear(.2):addx(100):zoom(0.1):diffusealpha(0)
		end,
		HideCommand = function(self)
			box_flag = false
			self:zoom(.3):linear(.1):zoom(0.1):diffusealpha(0)
		end
	},
	Def.Sprite {
		-- Texture=FILEMAN:DoesFileExist(path..'lua/Dialog/'..person..' 1x3.png') and '../lua/Dialog/'..person..' 1x3.png' or '../lua/Dialog/'..person..' 1x2.png',
		Texture = 'Dialog/Greta.png',
		OnCommand = function(self)
			self:CenterX():y(_screen.h * .50):zoom(.2*2):diffusealpha(0)
				:SetAllStateDelays(0.15):visible(true)
			if not bigImages then
				self:align(0.5, 1):xy(_screen.w * .10, _screen.h * .95):zoom(0.1*2)
			end
			text_actor["Greta"] = self
		end,
		ShowCommand = function(self)
			box_flag = true
			speaker = "Greta"
			text_actor.box:queuecommand('Show')
			self:CenterX():zoom(0.2*2):diffusealpha(0.9):linear(.1):zoom(0.4*2)
			if not bigImages then
				self:align(0.5, 1):xy(_screen.w * .10, _screen.h * .95):zoom(0.1*2)
			end
		end,
		HideBoxMessageCommand = function(self)
			box_flag = false
			self:linear(.2):addx(100):zoom(0.1):diffusealpha(0)
		end,
		HideCommand = function(self)
			box_flag = false
			self:zoom(.3):linear(.1):zoom(0.1):diffusealpha(0)
		end
	},
	Def.Sprite {
		Texture = "Dialog/box.png",
		OnCommand = function(self)
			self:CenterX():y(_screen.h * .85):zoom(.2):diffusealpha(0)
				:SetAllStateDelays(0.15)
			if bigImages then
				text_actor.box = self
				text_actor.box3 = self
			else
				self:visible(false)
			end
		end,
		ShowCommand = function(self)
			if not bigImages then
				self:visible(false)
			end
			self:zoom(0.2):diffusealpha(0.9):linear(.1):zoom(.3)
		end,
		HideBoxMessageCommand = function(self)
			self:zoom(.3):linear(.1):zoom(0.1):diffusealpha(0)
		end,
		HideCommand = function(self)
			self:zoom(.3):linear(.1):zoom(0.1):diffusealpha(0)
		end
	},
	 Def.BitmapText {
		File = '20px fonts/Work Sans Medium/_work sans medium 20px.ini',
		InitCommand = function(self)
			text_actor.speaker = self
			self:horizalign("left"):x(_screen.w * .15):y(_screen.h * .76):zoom(1)
				:vertalign("top")
		end,
		ShowCommand = function(self) self:x(_screen.w * .17):settext(speaker) end,
		TextClearCommand = function(self) self:settext('') end
	},
	 Def.BitmapText {
		File = '20px fonts/Work Sans Medium/_work sans medium 20px.ini',
		InitCommand = function(self)
			text_actor.mainText = self
			self:horizalign("left"):x(_screen.w * .16):y(_screen.h * .83):zoom(1.25)
				:vertalign("top"):wrapwidthpixels(640 / self:GetZoom())
		end,
		TypeCommand = function(self)
			if textCounter <= string.len(textMessage) then
				textCounter = textCounter + 1
				self:settext(string.sub(textMessage, 1, textCounter))
				if string.sub(textMessage, textCounter, textCounter) == ',' then
					self:sleep(textComma)
				elseif string.sub(textMessage, textCounter, textCounter) == '.' then
					self:sleep(textPeriod)
				elseif string.sub(textMessage, textCounter, textCounter) == '!' then
					self:sleep(textExclamation)
				elseif string.sub(textMessage, textCounter, textCounter) == '?' then
					self:sleep(textQuestion)
				end
				if textCounter % 4 == 0 then
					MESSAGEMAN:Broadcast('Talk')
				end
				self:sleep(textDefault)
				self:queuecommand('Type')
			else
				MESSAGEMAN:Broadcast('StopTalking')
			end
		end,
		TextClearCommand = function(self) self:settext('') end
	},
	Def.Sound{
		File="Voice.ogg",
		TalkMessageCommand=function(self)
			self:play()
		end,
	},
	
	LoadActor( "spells/starspell.lua" )..{
		OnCommand=function(self)
		
		starSpellCont=self
		self:visible(false)
		self:x(math.floor(SCREEN_CENTER_X))
		self:y(math.floor(SCREEN_CENTER_Y))
		
		end,
		
	},
	Def.Sound{
		File="sounds/Vroom.ogg",
		ShootMessageCommand=function(self)
			self:stop():play()
		end,
	},

	Def.Sound{
		File="sounds/pvZ.ogg",
		PVZMessageCommand=function(self)
			 self:play()
		end
	},
	Def.Sound{
		File="sounds/LevelComplete.ogg",
		SavedMessageCommand=function(self)
			 self:stop():play()
		end
	}
}

function createStarExplosion(x, y)
    for i = 1, 50 do
        t[#t+1] = Def.Sprite{
            Texture="star.png",
            InitCommand=function(self)
                self:diffusealpha(0)
            end,
            StarsMessageCommand=function(self)
                self:zoom(0.1)
                self:xy(x, y)
                self:diffuse(math.random(), math.random(), math.random(), math.random())
                self:zoom(math.random()*0.1 + 0.1)
                self:rotationz(math.random() * 360)
                self:accelerate(math.random() + 0.5)
                self:addx(math.random() * 2*SCREEN_WIDTH - SCREEN_WIDTH)
                self:addy(math.random() * 2*SCREEN_WIDTH - SCREEN_WIDTH)
                self:faderight(math.random() + 0.5)
                self:fadeleft(math.random() + 0.5)
                self:fadetop(math.random() + 0.5)
                self:fadebottom(math.random() + 0.5)
                self:decelerate(math.random() + 1)
                self:queuecommand("Remove")
            end,
            RemoveCommand=function(self) self:diffusealpha(0) end
        }
    end
end
for i = 1,10 do 
	local x = 7*SCREEN_WIDTH/8
	local y = 0
    t[#t+1] = Def.ActorFrame {
		InitCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_WIDTH*0.33, SCREEN_HEIGHT*0.83)
		end,
		ShootBugattiCommand=function(self)
			self:sleep(0.5)
			self:accelerate(1.5):zoom(0.4)
		end,
		Def.Sprite{
			Texture="Bugatti.png",
			InitCommand=function(self)
				self:visible(false)
				table.insert(bugattis, self)
				bugatti = bugatti + 1
			end,
			ShootBugattiCommand=function(self)
				self:sleep(0.5)
				self:GetParent():queuecommand("ShootBugatti")
				self:diffusealpha(1):visible(true)
				self:rotationy(180)
				self:decelerate(2):x(SCREEN_WIDTH*5)
			end
		},
	}
end

return t

-- Def.Sprite{
-- 	Texture='../lua/Dialog/_Miaa 1x2.png',
-- 	Frame0000=0,
-- 	Delay0000=0.6,
-- 	Frame0001=1,
-- 	Delay0001=0.6,
-- 	Frame0002=1,
-- 	Delay0002=0.1,
-- 	InitCommand=function(self)
-- 		self:CenterX():y(_screen.h*.85):zoom(.1):diffusealpha(0):SetAllStateDelays(0.15)
-- 		text_actor._Miaa = self
-- 	end,
-- 	ShowCommand=function(self)
-- 		box_flag = true
-- 		self:zoom(0.1):diffusealpha(1):linear(.1):zoom(.3)
-- 	end,
-- 	HideCommand=function(self)
-- 		box_flag = false
-- 		self:zoom(.3):linear(.1):zoom(0.1):diffusealpha(0)
-- 	end
-- },

-- Def.Sprite{
-- 	Texture='../lua/Dialog/Brandon 1x3.png',
-- 	InitCommand=function(self)
-- 		self:CenterX():y(_screen.h*.85):zoom(.1):diffusealpha(0):SetAllStateDelays(0.15)
-- 		text_actor.brandon = self
-- 	end,
-- 	ShowCommand=function(self)
-- 		box_flag = true
-- 		self:zoom(0.1):diffusealpha(1):linear(.1):zoom(.3)
-- 	end,
-- 	HideCommand=function(self)
-- 		box_flag = false
-- 		self:zoom(.3):linear(.1):zoom(0.1):diffusealpha(0)
-- 	end
-- },
